#ifndef LG_SPRITE_H
#define LG_SPRITE_H

//Attribute0
#define ROTATION_FLAG 		BIT08
#define SIZE_DOUBLE			BIT09
#define MODE_NORMAL     	0x0
#define MODE_TRANSPERANT	BIT10
#define MODE_WINDOWED		BIT11
#define MOSAIC				BIT12
#define COLOR_16			0x0000
#define COLOR_256			BIT13
#define SQUARE				0x0
#define WIDE				BIT14
#define TALL				BIT15

//Attribute1
#define ROTDATA(n)			((n) << 9)
#define HORIZONTAL_FLIP		BIT12
#define VERTICAL_FLIP		BIT13
#define SIZE_8				0x0
#define SIZE_16				BIT14
#define SIZE_32				BIT15
#define SIZE_64				BIT14 | BIT15

//Attribute2
#define PRIORITY(n)			((n) << 10)
#define PALETTE(n)			((n) << 12)


typedef struct
{
	u16 attribute0;
	u16 attribute1;
	u16 attribute2;
	u16 attribute3;
}OAMEntry;

#define TiledSpriteMem ((u16*)0x6010000)
#define BitmapSpriteMem ((u16*)0x6014000)
#define sprites ((OAMEntry*) 0x07000000)


void IWRAM_CODE ClearSpriteMem(void);
void IWRAM_CODE MoveSprite(OAMEntry* whatSprite, int x, int y);
void IWRAM_CODE RotateSprite(int rotDataIndex, int angle, s32 x_scale, s32 y_scale);

#endif





